<?php
require_once '../config.php';
verificarLogin();

$titulo = "Alterar Senha";
$security = new Security($pdo);

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Verificar CSRF
    if (!$security->verifyCSRFToken($_POST['csrf_token'])) {
        die("Token CSRF inválido!");
    }
    
    $senha_atual = $_POST['senha_atual'];
    $nova_senha = $_POST['nova_senha'];
    $confirmar_senha = $_POST['confirmar_senha'];
    
    // Buscar usuário atual
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE id = ?");
    $stmt->execute([$_SESSION['usuario_id']]);
    $usuario = $stmt->fetch();
    
    if (!password_verify($senha_atual, $usuario['senha'])) {
        $erro = "Senha atual incorreta!";
    } elseif ($nova_senha != $confirmar_senha) {
        $erro = "As novas senhas não coincidem!";
    } else {
        $password_errors = $security->validatePassword($nova_senha);
        if (!empty($password_errors)) {
            $erro = implode("<br>", $password_errors);
        } else {
            $nova_senha_hash = password_hash($nova_senha, PASSWORD_DEFAULT);
            
            $stmt = $pdo->prepare("UPDATE usuarios SET senha = ? WHERE id = ?");
            $stmt->execute([$nova_senha_hash, $_SESSION['usuario_id']]);
            
            // Registrar na auditoria
            $stmt = $pdo->prepare("INSERT INTO security_logs (usuario_id, acao, ip_address, user_agent) VALUES (?, ?, ?, ?)");
            $stmt->execute([$_SESSION['usuario_id'], 'alterar_senha', $_SERVER['REMOTE_ADDR'], $_SERVER['HTTP_USER_AGENT']]);
            
            $sucesso = "Senha alterada com sucesso!";
        }
    }
}

$csrf_token = $security->generateCSRFToken();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $titulo; ?> - Gestor DREEYTV</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        :root {
            --primary: #667eea;
            --secondary: #2d3748;
            --success: #48bb78;
            --danger: #f56565;
        }
        
        body {
            background: #f5f7fa;
            color: #2d3748;
        }
        
        .admin-container {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 280px;
            background: var(--secondary);
            color: white;
        }
        
        .sidebar-header {
            padding: 30px 25px;
            background: rgba(0,0,0,0.2);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        
        .sidebar-header h2 {
            font-size: 1.5rem;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
        }
        
        .sidebar-menu li {
            margin: 5px 15px;
        }
        
        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 15px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            border-radius: 10px;
            transition: all 0.3s;
        }
        
        .sidebar-menu a:hover {
            background: rgba(255,255,255,0.1);
            color: white;
        }
        
        .sidebar-menu a.active {
            background: var(--primary);
            color: white;
        }
        
        .main-content {
            flex: 1;
            padding: 30px;
        }
        
        .header {
            background: white;
            padding: 25px 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .header h1 {
            font-size: 1.8rem;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .user-avatar {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary), #5a6fd8);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
        }
        
        .content {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            max-width: 600px;
            margin: 0 auto;
        }
        
        .form-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .form-header .icon {
            font-size: 3rem;
            margin-bottom: 10px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #2d3748;
        }
        
        .form-control {
            width: 100%;
            padding: 15px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 16px;
            transition: all 0.3s;
        }
        
        .form-control:focus {
            border-color: var(--primary);
            outline: none;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .btn {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            padding: 15px 25px;
            background: var(--primary);
            color: white;
            text-decoration: none;
            border-radius: 10px;
            font-weight: 600;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
        }
        
        .btn-block {
            display: block;
            width: 100%;
        }
        
        .alert {
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
        }
        
        .alert-success {
            background: #c6f6d5;
            color: #22543d;
            border: 1px solid #9ae6b4;
        }
        
        .alert-danger {
            background: #fed7d7;
            color: #742a2a;
            border: 1px solid #feb2b2;
        }
        
        .password-info {
            font-size: 0.8rem;
            color: #666;
            margin-top: 5px;
        }
        
        .password-requirements {
            background: #f7fafc;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            font-size: 0.8rem;
        }
        
        .requirement {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 5px;
        }
        
        .requirement.valid {
            color: #22543d;
        }
        
        .requirement.invalid {
            color: #742a2a;
        }
        
        @media (max-width: 768px) {
            .admin-container {
                flex-direction: column;
            }
            
            .sidebar {
                width: 100%;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <div class="sidebar">
            <div class="sidebar-header">
                <h2>📺 GESTOR DREEYTV</h2>
            </div>
            <ul class="sidebar-menu">
                <li><a href="../index.php">📊 Dashboard</a></li>
                <li><a href="../clientes/clientes.php">👨‍💼 Clientes</a></li>
                <li><a href="../planos/planos.php">📋 Planos</a></li>
                <li><a href="../servidores/servidores.php">🖥️ Servidores</a></li>
                <?php if ($_SESSION['usuario_tipo'] == 'admin'): ?>
                    <li><a href="../usuarios/usuarios.php">👥 Usuários</a></li>
                <?php endif; ?>
                <li><a href="alterar_senha.php" class="active">🔑 Alterar Senha</a></li>
                <li><a href="../logout.php">🚪 Sair</a></li>
            </ul>
        </div>
        
        <div class="main-content">
            <div class="header">
                <h1>Alterar Senha</h1>
                <div class="user-info">
                    <div class="user-avatar"><?php echo substr($_SESSION['usuario_nome'], 0, 1); ?></div>
                    <div>
                        <div style="font-weight: 600;"><?php echo $_SESSION['usuario_nome']; ?></div>
                        <div style="font-size: 0.9rem; color: #666;"><?php echo ucfirst($_SESSION['usuario_tipo']); ?></div>
                    </div>
                    <a href="../logout.php" class="btn" style="background: var(--danger);">🚪 Sair</a>
                </div>
            </div>
            
            <div class="content">
                <div class="form-header">
                    <div class="icon">🔐</div>
                    <h2>Alterar Senha</h2>
                    <p style="color: #666;">Atualize sua senha de acesso ao sistema</p>
                </div>
                
                <?php if (isset($erro)): ?>
                    <div class="alert alert-danger">
                        <strong>❌ Erro:</strong> <?php echo $erro; ?>
                    </div>
                <?php endif; ?>
                
                <?php if (isset($sucesso)): ?>
                    <div class="alert alert-success">
                        <strong>✅ Sucesso!</strong> <?php echo $sucesso; ?>
                    </div>
                <?php endif; ?>
                
                <div class="password-requirements">
                    <strong>🔒 Requisitos de Senha:</strong>
                    <div class="requirement invalid" id="req-length">✓ Pelo menos 8 caracteres</div>
                    <div class="requirement invalid" id="req-uppercase">✓ Pelo menos uma letra maiúscula</div>
                    <div class="requirement invalid" id="req-lowercase">✓ Pelo menos uma letra minúscula</div>
                    <div class="requirement invalid" id="req-number">✓ Pelo menos um número</div>
                    <div class="requirement invalid" id="req-special">✓ Pelo menos um caractere especial</div>
                </div>
                
                <form method="POST" id="passwordForm">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    
                    <div class="form-group">
                        <label class="form-label" for="senha_atual">🔒 Senha Atual</label>
                        <input type="password" id="senha_atual" name="senha_atual" class="form-control" placeholder="Digite sua senha atual" required>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="nova_senha">🔄 Nova Senha</label>
                        <input type="password" id="nova_senha" name="nova_senha" class="form-control" placeholder="Digite a nova senha" required>
                        <div class="password-info">A senha deve atender a todos os requisitos acima</div>
                    </div>
                    
                    <div class="form-group">
                        <label class="form-label" for="confirmar_senha">✅ Confirmar Nova Senha</label>
                        <input type="password" id="confirmar_senha" name="confirmar_senha" class="form-control" placeholder="Confirme a nova senha" required>
                    </div>
                    
                    <button type="submit" class="btn btn-block" id="submitBtn" style="margin-top: 20px;" disabled>
                        🔄 Atualizar Senha
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('nova_senha').addEventListener('input', function(e) {
            const password = e.target.value;
            
            // Verificar requisitos
            const hasLength = password.length >= 8;
            const hasUppercase = /[A-Z]/.test(password);
            const hasLowercase = /[a-z]/.test(password);
            const hasNumber = /[0-9]/.test(password);
            const hasSpecial = /[^A-Za-z0-9]/.test(password);
            
            // Atualizar visual dos requisitos
            document.getElementById('req-length').className = hasLength ? 'requirement valid' : 'requirement invalid';
            document.getElementById('req-uppercase').className = hasUppercase ? 'requirement valid' : 'requirement invalid';
            document.getElementById('req-lowercase').className = hasLowercase ? 'requirement valid' : 'requirement invalid';
            document.getElementById('req-number').className = hasNumber ? 'requirement valid' : 'requirement invalid';
            document.getElementById('req-special').className = hasSpecial ? 'requirement valid' : 'requirement invalid';
            
            // Habilitar/desabilitar botão
            const allValid = hasLength && hasUppercase && hasLowercase && hasNumber && hasSpecial;
            document.getElementById('submitBtn').disabled = !allValid;
        });

        // Validação em tempo real para confirmação de senha
        document.addEventListener('DOMContentLoaded', function() {
            const novaSenha = document.getElementById('nova_senha');
            const confirmarSenha = document.getElementById('confirmar_senha');
            
            function validarSenhas() {
                if (novaSenha.value && confirmarSenha.value) {
                    if (novaSenha.value !== confirmarSenha.value) {
                        confirmarSenha.style.borderColor = 'var(--danger)';
                    } else {
                        confirmarSenha.style.borderColor = 'var(--success)';
                    }
                }
            }
            
            novaSenha.addEventListener('input', validarSenhas);
            confirmarSenha.addEventListener('input', validarSenhas);
        });

        document.getElementById('passwordForm').addEventListener('submit', function(e) {
            const password = document.getElementById('nova_senha').value;
            const hasLength = password.length >= 8;
            const hasUppercase = /[A-Z]/.test(password);
            const hasLowercase = /[a-z]/.test(password);
            const hasNumber = /[0-9]/.test(password);
            const hasSpecial = /[^A-Za-z0-9]/.test(password);
            
            if (!(hasLength && hasUppercase && hasLowercase && hasNumber && hasSpecial)) {
                e.preventDefault();
                alert('Por favor, atenda a todos os requisitos de senha!');
            }
        });
    </script>
</body>
</html>